# 高擎电机调试助手使用说明书





## 0. 适用版本说明

- 本**说明书**适用于高擎调试助手v0.11.1及以上版本。
- **高擎调试助手**适用于电机固件在v3.1.0及以上版本。

## **1. 电机使用须知** 

### **1.1  电机的硬件接线** 

1. 电机额定电压：24VDC
2. 调试接线：

① 电机XT30(2+2)接口与FDCAN模块相连，FDCAN模块typc接口连接电脑。 

- 电机型号：5047、4438

![1](./picture/1.JPEG)

② 电机XT30接口与FDCAN模块相连，FDCAN模块typc接口连接电脑，用GH1.25_3P线连接电机和FDCAN模块，电机电源接FDCAN模块。 

- 电机型号：5046

![2](./picture/2.JPEG)

## **2. 高擎电机调试助手使用方法及说明**

### 2**.1  基本信息及功能**

1. **重连USBCAN设备：**扫描连接USBCAN设备并检测是否连接到电机，**如调试过程中断连或多个电机识别不全可再次点击“重连USBCAN设备”**。
2. **输出信息：**电机连接的打印信息、电机校准信息输出等。
3. **常用功能**
   - **电机ID：**显示当前连接电机的ID；
   - **电机校准：**重新校准电机，**校准过程中电机不要有任何负载**，同时在输出信息窗口打印校准过程以及在下方显示进度；
   - **重置当前电机零位：**将“电机ID”所选择的单个电机重置零位；
   - **重置全部电机零位：**将上位机所识别到的全部电机重置零位；
   - **更新电机固件：**选择的固件更新至电机中，会有信息打印输出；
4. **语言：**支持中文、英文界面；

![3](./picture/3.png)

### 2**.2  参数设置**

- 读参数和写参数可读取与修改电机的以下参数（电机保护、PID调节、修改电机ID、电机位置范围、转动限制）

1. **基本信息：**显示电机的基本信息；
2. **电机保护：**超过电压或温度限定值电机报错并停止转动，更改后写入参数；
3. **PID调节：**电机内部PID（i_limt是积分限制），更改后写入参数；
4. **修改电机ID：**更改电机ID，并重新识别电机，更改后写入参数；
5. **电机位置范围：**控制电机位置最大和最小的范围（nan表示无限制），更改后写入参数；
6. **转动限制：**设置电机速度、加速度和电流限制（nan表示无限制），更改后写入参数；

![4](./picture/4.png)

### 2**.3  电机调试**

1. **电机运行模式：**以不同运行模式调试（详细查看2.4）；
2. **电机状态：**点击“**添加波形**”可以显示电机位置、速度、力矩的波形和温度及电机状态（非零值为电机报错代码，具体原因查附录报错代码说明表）；
3. **生成帧：**电机当前运行状态的FDCAN帧信息（可选float、int16、int32、CAN帧）；
   - **float、int16、int32：**具体程序函数查看 “高擎电机fdcan协议解析中的CAN_H730/Src/livelybot_fdcan/livelybot_fdcan.c”（例子查看第3章 ”生成帧例子解析“）；
   - **CAN帧：**具体程序函数查看 “高擎电机can协议解析/can_h730/App/livelybot/livelybot_can.c”（使用方式同上，只不过资料在”高擎电机can协议解析“中）。
4. **停止与刹车：**
   
   - **停止：**停止是三相都断开，点击停止后电机还有一定的惯性慢慢停住；
   
   - **刹车：**刹车是三相都接地，点击刹车后电机立刻停止；

![5](./picture/5.png)

### 2**.4  电机运行模式说明**

1. **位置模式：**设定位置点击发送，电机以**最大加速度**、**速度**转动到指定位置，如在参数设置里设定了加速度和速度，则以设定的加速度和速度转到指定位置。

![6](./picture/6.png)

2. **速度模式：**设定速度点击发送，电机以**最大加速度**转到指定速度，如在参数设置里设定了加速度限制，则以设定的加速度转到指定速度转动。

![7](./picture/7.png)

3. **力矩模式：**设定力矩点击发送，电机按指定的力矩进行输出，如外部阻力大于设定的力矩，电机会堵转。

![8](./picture/8.png)

4. **电压模式：**设定Q相电压发送，给定电机指定的Q相电压。

![9](./picture/9.png)

5. **电流模式：**设定Q相电流发送，给定电机指定的Q相电流。

![10](./picture/10.png)

6. **位置、速度、最大力矩：**电机以指定速度转动到指定位置停止，并限制输出力矩大小，如不想限制力矩大小，可将最大力矩设定为NAN。

![11](./picture/11.png)

7. **梯形控制：**设定以下三个参数发送，电机会以指定加速度缓慢转到指定速度后匀速转动，接近目标位置时再缓慢减速直至到目标位置停止。

![12](./picture/12.png)

8. **运控模式：**电机输出力矩 = 位置偏差 * Kp + 速度偏差 * Kd + 力矩。

![13](./picture/13.png)

## 3**.** 生成帧例子解析

需更详细的解析请查看 ”**高擎电机fdcan协议解析**“ 中的 ”**fdcan.pdf**“ 和 ”**寄存器功能、电机运行模式、报错代码、一托多模式说明.xlsx**“文档。

**以int32数据帧速度模式为例解析：** **`01000a0a2000000080204e0000`**

1. **子帧 1**：整体意思是电机进入位置模式

- `0x01` ：第一个子帧的开头 
  - 高四位为 0000 ，表示写操作。 
  - 低四位： 
    - 高 2 位为： 00 ，表示 int8_t 类型。 
    - 低 2 位为： 01 ，表示 1 个数据。 
- `0x00` ：起始寄存器地址：查表可知， 0x00 寄存器表示电机模式设置。 （表在寄存器功能、报错代码、一托多模式说明.xlsx）
- `0x0a` ：往 0x00 寄存器写入 0x0a 。

2. **子帧 2**：整体意思是位置不限制，速度为 0.2 转/秒

- `0x0a` ：第 2 个子帧的开头 
  - 高四位为 0000 ，表示写操作。 
  - 低四位： 
    - 高 2 位为： 10 ，表示 int32_t 类型。 
    - 低 2 位为： 10 ，表示 2 个数据。 
- `0x20 `：起始寄存器地址：查表可知， 0x20 寄存器表示位置， 0x21 寄存器表示速度。 
- `0x00、0x00、0x00、0x80` ：小端模式，即 0x80000000 写入 0x20 寄存器，即表示电机位置无限制。 
- `0x20、0x4e、0x00、0x00` ：小端模式，即 0x4e20 写入 0x21 寄存器，表示电机速度设置为 0.2 转/秒。
  - `0x4e20`换算10进制时20000，由下表知， `int32`类型值为100000时电机实际是1转/秒，20000就是0.2转/秒。（表在文档fdcan.pdf的2.7节）

![14](./picture/14.png)



# 附录

## **1、报错代码说明表**

| 报错代码说明表 |              |                                                  |
| -------------- | ------------ | ------------------------------------------------ |
| 报错代码       | 名称         | 说明                                             |
| 32             | 校准故障     | 校准过程中，编码器无法感知到磁铁                 |
| 33             | 电机驱动故障 | 多为欠压，电流不足                               |
| 34             | 过压         | 母线电压过大                                     |
| 35             | 编码器故障   | 编码器读数错误                                   |
| 36             | 电机未校准   | 电机还未进行校准（电机出厂都会校准一次）         |
| 37             | PWM周期过限  | 一般是内部固件错误                               |
| 38             | 温度过高     | 已超过最大配置温度                               |
| 39             | 超出界限     | 在位置界限之外尝试启动位置控制（出厂无位置限制） |
| 40             | 电压过低     | 电压太低                                         |
| 41             | 配置已更改   | 在操作期间更改了需要停止的配置值                 |
| 42             | 角度无效     | 没有可用的有效换相编码器                         |
| 43             | 位置无效     | 没有可用的有效输出编码器                         |